
use "\\micro.intra\Projekt\P0624$\P0624_Gem\Data Extraction and Files\Data files\ceo_panel.dta", clear
duplicates drop p_id year, force
drop if year>2012
drop partner_id gift
joinby p_id year using "\\micro.intra\Projekt\P0624$\P0624_Gem\Data Extraction and Files\Data files\partner_panel_ceo.dta", unmatched(master) _merge(_merge)
cd "\\micro.intra\Projekt\P0624$\P0624_Gem\Data Extraction and Files\Data files"
append using partner_ceo_13_14
drop _merge
fillin year p_id
 
cd  "\\micro.intra\Projekt\P0624$\P0624_Gem\Data Extraction and Files\Figures population comparisons\firms"
 
joinby o_nr year using "firms 20 emp 2001_2012.dta" , unmatched(master)
drop _merge
   

sort p_id year	
	
forvalues n=0/5{
	local y=`n'-1
	gen rem_mar1_`n'= partner_id[_n-1]== partner_id[_n+`y'] if  partner_id[_n-1]!=.  & p_id==p_id[_n+`y']
}

forvalues v=2/5{
	sort p_id year
	local x=`v'-1

forvalues n=1/`x'{
	local y=-`n'-1
	gen rem_mar`v'_n`n'= partner_id[_n-`v']== partner_id[_n+`y'] if  partner_id[_n-`v']!=. & p_id==p_id[_n+`y'] 
}

forvalues n=0/5{
	local y=`n'-1
	gen rem_mar`v'_`n'= partner_id[_n-`v']== partner_id[_n+`y'] if  partner_id[_n-`v']!=.  & p_id==p_id[_n+`y'] 
}
}

sort p_id year
gen ceo_samp=ceo_prev==0 & ceo==1 & year>2004 & year<2011 &empl>100 & empl!=. & age<63
gen ceoint_samp=ceo_prev==0 & ceo==1 & year>2004 & year<2011 &empl>100 & empl!=. & age<63 ///
	& o_nr==o_nr[_n-1] & o_nr==o_nr[_n-2] &  o_nr==o_nr[_n-3]  



foreach sam in ceoint_samp{
	foreach var in  rem_mar5{
		matrix C =J(14,3,.)
		forvalues n=1/4{
	 
			local num=`n'
			scalar exp=-`num'
			matrix C[`n',1]=exp
			sum `var'_n`num'  if  `sam'==1  & woman==1
			matrix C[`n',2]=r(mean)
			sum `var'_n`num'  if `sam'==1   & woman==0 
			matrix C[`n',3]=r(mean)
		}
		forvalues n=0/4{
			scalar exp=`n' 
			local num=`n'+5
			matrix C[`num',1]=exp
			sum `var'_`n'  if  `sam'==1 & woman==1 
			matrix C[`num',2]=r(mean)
			sum `var'_`n'  if `sam'==1 & woman==0
			matrix C[`num',3]=r(mean)

		}
	
		svmat C
		rename C1 time
		rename C2 prom
		rename C3 noprom
		sort time
	
		graph twoway (connect prom noprom  time ,lc(gs1 gs10) mc(gs1  gs10) ms(circle  circle) ///
		lw(medthick medthick ) lp(solid solid  )), ///
		 xline(.5, lwidth(medium) lpattern(solid) lcolor(black))  xlabel(-4(1)4)  ///
		title(XXX)  ytitle(Remain Married) xtitle(Years from Promotion)  scheme(s1mono) ///
		 legend(on order(1 "Women" 2 "Men") rows(1))
		graph save prom_`sam'_`var', replace
		drop time -noprom
	}
}


foreach sam in ceoint_samp{
	foreach var in  rem_mar5{
		matrix C =J(14,4,.)
		forvalues n=1/3{ 
			local num=`n'
			scalar exp=-`num'
			matrix C[`n',1]=exp
			reg `var'_n`num' woman  if  `sam'==1  
			matrix C[`n',2]=_b[woman]*100
			matrix C[`n',3]=(_b[woman]+1.96*_se[woman])*100
			matrix C[`n',4]=(_b[woman]-1.96*_se[woman])*100
		}
		forvalues n=0/4{
			scalar exp=`n' 
			local num=`n'+4
			matrix C[`num',1]=exp
			reg `var'_`n' woman  if  `sam'==1  
			matrix C[`num',2]=_b[woman]*100
			matrix C[`num',3]=(_b[woman]+1.96*_se[woman])*100
			matrix C[`num',4]=(_b[woman]-1.96*_se[woman])*100
		}
		
		svmat C
		rename C2 w_estimate
		rename C3 w_upper
		rename C4 w_lower
		rename C1 w_year

		twoway (rbar w_upper w_lower w_year if w_upper!=w_lower, fcolor(black) lcolor(none) barwidth(.05)) ///
		(scatter w_estimate w_year if w_upper!=w_lower, mcolor(black) msize(medium) msymbol(circle)) , ///
		xline(.5, lwidth(medium) lpattern(solid) lcolor(black))  xlabel(-3(1)4)  ///
		yline(0, lwidth(medthick) lpattern(dash) lcolor(black))  ///
		title(XXX)  ytitle(Estimated Gender Difference) xtitle(Years from Promotion)  scheme(s1mono)
		graph save regprom_`sam'_`var', replace
		drop w_year -  w_lower
	}
}


foreach sam in ceoint_samp_sh{

foreach var in  rem_mar3{

	matrix C =J(14,3,.)
	forvalues n=1/2{
	 
	local num=`n'
	scalar exp=-`num'
	
		matrix C[`n',1]=exp
		sum `var'_n`num'  if  `sam'==1  & woman==1
		matrix C[`n',2]=r(mean)
		sum `var'_n`num'  if `sam'==1   & woman==0 
		matrix C[`n',3]=r(mean)

	}
		forvalues n=0/3{
	scalar exp=`n' 
	local num=`n'+3
		matrix C[`num',1]=exp
		sum `var'_`n'  if  `sam'==1 & woman==1 
		matrix C[`num',2]=r(mean)
		sum `var'_`n'  if `sam'==1 & woman==0
		matrix C[`num',3]=r(mean)

}
	
		svmat C
	rename C1 time
	rename C2 prom
	rename C3 noprom
	sort time
	
	graph twoway (connect prom noprom  time ,lc(gs1 gs10) mc(gs1  gs10) ms(circle  circle) ///
	lw(medthick medthick ) lp(solid solid  )), ///
	 xline(.5, lwidth(medium) lpattern(solid) lcolor(black))  xlabel(-2(1)3)  ///
	title(XXX)  ytitle(Remain Married) xtitle(Years from Promotion)  scheme(s1mono) ///
	 legend(on order(1 "Women" 2 "Men") rows(1))
	graph save prom_`sam'_`var', replace
	drop time -noprom

}

}


		
graph combine prom_ceoint_samp_rem_mar5.gph regprom_ceoint_samp_rem_mar5.gph , ysize(8) xsize(20) iscale(1.3)   scheme(s1mono)
graph save  ceo_comb, replace
	
